<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 07.01.14 10:13
 */

namespace VM\ApiBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\ApplicationRole;
use VM\ApiBundle\Entity\User;

class ImportMultibookUserFromAuthCommand extends ContainerAwareCommand
{

    protected function configure()
    {
        $this
            ->setName('import:multibookweb:auth:users')
            ->setDescription('Importuje użytkowników z autha do sso i tworzy odpowiednie wpisy w auth.')
            ->addOption('auth_dbname', null, InputOption::VALUE_REQUIRED, 'Nazwa bazy danych autha.')
            ->addOption('auth_dbuser', null, InputOption::VALUE_REQUIRED, 'Użytkownik z dostępem do bazy autha.')
            ->addOption('auth_dbuser_password', null, InputOption::VALUE_REQUIRED, 'Hasło użytkownika z dostępem do autha.')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $sso_dbname = $this->getContainer()->getParameter('database_name');
        $sso_dbuser = $this->getContainer()->getParameter('database_user');
        $sso_dbuser_password = $this->getContainer()->getParameter('database_password');
        $auth_dbname = $input->getOption('auth_dbname');
        $auth_dbuser = $input->getOption('auth_dbuser');
        $auth_dbuser_password = $input->getOption('auth_dbuser_password');
        if(empty($auth_dbname) || empty($auth_dbuser) || empty($auth_dbuser_password)) {
            $output->writeln('Brak wymaganych parametrów.');
        } else {
            $this->connectToDB(
                $auth_dbname,
                $auth_dbuser,
                $auth_dbuser_password
            );

            $EntityManager = $this->getContainer()->get('doctrine')->getManager();
            $stmt = $EntityManager
                ->getConnection()
                ->prepare('SELECT * FROM ma_user_books');
            $stmt->execute();
            $AuthUsers = $stmt->fetchAll();
            $output->writeln('Użytkowników do przeniesienia: '.count($AuthUsers));

            $this->connectToDB(
                $sso_dbname,
                $sso_dbuser,
                $sso_dbuser_password
            );

            $EntityManager = $this->getContainer()->get('doctrine')->getManager();

            $authSsoConnectionsByIds = array();

            $EntityManager->getConnection()->beginTransaction();
            $output->writeln('Tworzenie rekordów w SSO');
            $output->writeln('Zapis nowych użytkowników');
            $newUsersCount = 0;
            $progress = $this->getHelper('progress');
            $progress->start($output, count($AuthUsers));
            $existingSsoUsers = [];

            foreach ($AuthUsers as $AuthUser) {
                $User = $EntityManager->getRepository('VMApiBundle:User')->findOneBy(array('username' => $AuthUser['login']));
                $Application = $EntityManager->getRepository('VMApiBundle:Application')->findOneBy(array('symbol' => 'PODRECZNIKI'));
                $ApplicationRole = $EntityManager->getRepository('VMApiBundle:ApplicationRole')
                    ->findOneBy(array('application' => $Application, 'symbol' => 'ROLE_USER'));
                if (empty($User)) {
                    $User = new User();
                    $EntityManager->persist($User);
                    $User->addAppRole($ApplicationRole);
                    $ApplicationRole->addUser($User);
                    $newUsersCount++;

                    $User->setUsername($AuthUser['login']);
                    $User->setUsernameCanonical($AuthUser['login']);
                    $User->setEmail($AuthUser['login']);
                    $User->setEmailCanonical($AuthUser['login']);
                    $User->setEnabled(true);
                    $User->setLocked(false);
                    $User->setName(isset($AuthUser['name'])? $AuthUser['name']: $AuthUser['login']);
                    $User->setSurname(isset($AuthUser['surname'])? $AuthUser['surname']: $AuthUser['login']);
                    $User->setLastLogin(new \DateTime($AuthUser['last_login']));
                    $User->setCredentialsExpired(false);
                    $User->setCredentialsExpireAt(null);
                    $User->setExpired(false);
                    $User->setExpiresAt(null);
                    $User->setPasswordRequestedAt(null);
                    $User->setMaxAllowedTokens(3);
                    $User->setPasswordRecoveryToken(null);
                    $User->setExternalId(null);

                    $salt = sha1(rand(10000, 99999));
                    $password = hash('sha512', $AuthUser['pass'] . $salt);
                    $User->setSalt($salt);
                    $User->setPassword($password);
                } else {
                    $existingSsoUsers[] = $AuthUser['login'];
//                    if (!$this->hasUserRole($User, $ApplicationRole)) {
//                        $User->addAppRole($ApplicationRole);
//                        $ApplicationRole->addUser($User);
//                    }
                }

                $authSsoConnectionsByIds[] = array('login' => $AuthUser['login'], 'ma_user_books_id' => $AuthUser['id']);
                $progress->advance();
            }

            $EntityManager->flush();
            $EntityManager->getConnection()->commit();
            $progress->finish();
            $output->writeln('');
            $output->writeln(implode(',', $existingSsoUsers));
            $output->writeln('');
            $output->writeln('Nowych użytkowników: '.$newUsersCount);

            foreach ($authSsoConnectionsByIds as $key => $conn) {
                $authSsoConnectionsByIds[$key]['sso_id'] =
                    $this->getContainer()->get('doctrine')->getRepository('VMApiBundle:User')
                        ->findOneBy(array('email' => $conn['login']))->getId();
            }

            $this->connectToDB(
                $auth_dbname,
                $auth_dbuser,
                $auth_dbuser_password
            );
            $EntityManager = $this->getContainer()->get('doctrine')->getManager();

            $output->writeln('');
            $output->writeln('Tworzenie rekordów w AUTH');
            $output->writeln('Zapis użytkowników z sso');

            $EntityManager->getConnection()->beginTransaction();
            $progress->start($output, count($authSsoConnectionsByIds));

            foreach ($authSsoConnectionsByIds as $ssoAuthIds) {
                $stmt = $EntityManager
                    ->getConnection()
                    ->prepare('SELECT * FROM ma_sso_users WHERE sso_id = '.$ssoAuthIds['sso_id']);
                $stmt->execute();
                $fetched = $stmt->fetch();
                $MaSsoUserId = isset($fetched['id']) ? $fetched['id'] : false;

                if (empty($MaSsoUserId)) {
                    $stmt = $EntityManager
                        ->getConnection()
                        ->prepare('INSERT INTO ma_sso_users (sso_id) VALUES('.$ssoAuthIds['sso_id'].')');
                    $stmt->execute();
                }
                $progress->advance();
            }
            $progress->finish();

            $output->writeln('Przepisanie kodów na użytkowników z sso');
            $progress->start($output, count($authSsoConnectionsByIds));
            foreach ($authSsoConnectionsByIds as $ssoAuthIds) {
                $stmt = $EntityManager
                    ->getConnection()
                    ->prepare('SELECT * FROM ma_sso_users WHERE sso_id = '.$ssoAuthIds['sso_id']);
                $stmt->execute();
                $MaSsoUser = $stmt->fetch();
                $MaSsoUserId = $MaSsoUser['id'];

                $stmt = $EntityManager
                    ->getConnection()
                    ->prepare('SELECT * FROM ma_user_books_codes WHERE user_books_id = '.$ssoAuthIds['ma_user_books_id']);
                $stmt->execute();
                $Codes = $stmt->fetchAll();

                foreach ($Codes as $Code) {
                    $stmt = $EntityManager
                        ->getConnection()
                        ->prepare('SELECT * FROM ma_sso_user_codes WHERE sso_user_id = '.$MaSsoUserId.' AND code_id = '.$Code['codes_id']);
                    $stmt->execute();
                    $ExistingCode = $stmt->fetch();

                    if (empty($ExistingCode)) {
                        $stmt = $EntityManager
                            ->getConnection()
                            ->prepare('INSERT INTO ma_sso_user_codes VALUES('.$MaSsoUserId.', '.$Code['codes_id'].')');
                        $stmt->execute();
                    }
                }
                $progress->advance();
            }
            $EntityManager->getConnection()->commit();
            $progress->finish();
            $output->writeln('');
            $output->writeln('Koniec operacji');
        }
    }

    protected function hasUserRole(User $User, ApplicationRole $ApplicationRole)
    {
        return $User->getAppRoles()->exists(function($key, ApplicationRole $role) use($ApplicationRole)
            {
                return $ApplicationRole->getSymbol() === $role->getSymbol();
            });
    }

    protected function connectToDB($dbname, $user, $pass)
    {
        $connection = $this->getContainer()->get('doctrine.dbal.default_connection');
        $connection->close();

        $refConn = new \ReflectionObject($connection);
        $refParams = $refConn->getProperty('_params');
        $refParams->setAccessible('public'); //we have to change it for a moment

        $params = $refParams->getValue($connection);
        $params['dbname'] = $dbname;
        $params['user'] = $user;
        $params['password'] = $pass;

        $refParams->setAccessible('private');
        $refParams->setValue($connection, $params);
        $this->getContainer()->get('doctrine')->resetManager('default');
    }
} 